function residual = static_resid(T, y, x, params, T_flag)
% function residual = static_resid(T, y, x, params, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T         [#temp variables by 1]  double   vector of temporary terms to be filled by function
%   y         [M_.endo_nbr by 1]      double   vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1]       double   vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1]     double   vector of parameter values in declaration order
%                                              to evaluate the model
%   T_flag    boolean                 boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Cartel_VD.static_resid_tt(T, y, x, params);
end
residual = zeros(66, 1);
residual(1) = T(2)*exp(y(1))*exp(y(4))+T(4)+params(21)*y(57)-y(57);
residual(2) = T(2)*(-exp(y(2)))+y(63)*(-T(5))+y(50)*(-(T(6)*params(4)*exp(y(2)*params(4))))+exp(y(2))*y(39)+params(21)*y(59)-y(59)+params(21)*y(63)*T(5);
residual(3) = y(63)*(-T(7))+y(49)*(-(T(8)*params(4)*exp(y(3)*params(4))))+y(45)*y(14)*T(8)*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1))+exp(y(3))*y(39)+params(21)*y(58)-y(58)+params(21)*y(63)*T(7);
residual(4) = T(2)*T(9)+y(64)*(-T(10))+y(53)*(-exp(y(4)))+exp(y(4))*y(52)+params(21)*y(61)-y(61)+params(21)*y(64)*T(10);
residual(5) = y(64)*(-T(11))+y(53)*(-exp(y(5)))+exp(y(5))*y(51)+params(21)*y(60)-y(60)+params(21)*y(64)*T(11);
residual(6) = T(12);
residual(7) = T(13);
residual(8) = y(50)*exp(y(8))+y(48)*(-(exp(y(8))*params(7)))+params(21)*y(50)*(-(exp(y(8))*(1-params(7))));
residual(9) = y(49)*exp(y(9))+y(47)*(-(params(7)*exp(y(9))))+params(21)*y(49)*(-((1-params(7))*exp(y(9))));
residual(10) = T(14)+params(21)*y(56)*(-exp(y(10)));
residual(11) = params(21)*y(51)*(-(exp(y(11))*exp(y(7))))+y(46)*exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T(16)+params(21)*y(39)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(21)*y(47)*(-(exp(y(7))*(-exp(y(11)))));
residual(12) = exp(y(12))*y(38);
residual(13) = y(44)*(-params(7))+y(43)+T(3)*y(43)*(-(exp(y(22))*(1-exp(y(11)))))+T(3)*exp(y(22))*y(46);
residual(14) = y(45)*T(8)*params(4)*exp(y(3)*(params(4)-1))+y(44)+T(3)*y(44)*(-(exp(y(22))*(1-params(7))));
residual(15) = y(53)*exp(y(15))+y(35)*(-(params(11)*T(17)*T(19)))+y(34)*(-(params(11)*T(21)*T(27)));
residual(16) = y(39)*(-exp(y(16)))+y(37)*(-(T(23)*T(28)*T(29)*exp(T(20)*y(23))*(1-params(11))*params(3)*T(30)))+y(36)*(-(T(31)*T(22)*T(29)*T(30)*exp(T(20)*y(23))*(1-params(11))*(1-params(3))))+y(35)*(-(T(32)*params(11)*T(30)))+exp(y(16))*y(34)+params(21)*y(62)-y(62);
residual(17) = y(39)*exp(y(17))+params(21)*y(34)*(-(T(27)*T(35)))+params(21)*y(36)*(-(T(31)*T(39)))+params(21)*y(37)*T(42)+params(21)*y(38)*(-(exp(y(18)*(1-params(3)))*exp(T(20)*y(23))*params(3)*exp(y(17)*params(3))))+params(21)*y(39)*(-(exp(y(17))*(1-params(10))));
residual(18) = (T(9)-exp(y(2)))*T(46)+y(42)*(-(T(46)*params(1)/T(2)))+exp(y(18))*y(40)+y(38)*T(47)+y(37)*(-(T(28)*T(29)*T(40)*T(48)+T(23)*T(28)*T(40)*T(37)*T(22)*T(48)))+y(36)*(-(T(31)*T(22)*T(36)*T(37)*T(22)*T(48)+T(22)*T(29)*T(36)*T(49)))+y(34)*(-(T(27)*T(50)))+params(21)*y(42)*(-((-(T(46)*T(2)*params(1)))/(T(2)*T(2))));
residual(19) = (T(9)-exp(y(2)))*exp(y(19))*T(45)+y(42)*(-(params(1)*exp(y(19))*T(45)/T(2)))+exp(y(19))*y(39)+params(21)*y(42)*(-((-(T(2)*params(1)*exp(y(19))*T(45)))/(T(2)*T(2))));
residual(20) = y(37)*exp(y(20))+T(3)*y(41)*(-(exp(y(22))*exp(y(20))));
residual(21) = y(40)*(-(T(51)*T(52)))+y(36)*exp(y(21));
residual(22) = T(55);
residual(23) = y(55)+params(21)*y(55)*(-params(15))+y(38)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T(20)*exp(T(20)*y(23))))+y(37)*(-(T(23)*T(28)*T(29)*T(17)*(1-params(11))*params(3)*T(20)*exp(T(20)*y(23))))+y(36)*(-(T(31)*T(22)*T(29)*T(17)*(1-params(11))*(1-params(3))*T(20)*exp(T(20)*y(23))))+y(34)*(-(T(27)*T(56)))+T(57)*y(55)*(-params(16));
residual(24) = T(2)*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T(58)))+y(54)+T(59);
residual(25) = y(57);
residual(26) = y(58);
residual(27) = y(59);
residual(28) = y(60);
residual(29) = y(61);
residual(30) = y(62);
residual(31) = T(2)*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T(58)))+y(56)*exp(y(31));
residual(32) = y(63);
residual(33) = y(64);
residual(34) = exp(y(16))-T(26)^(params(2)/(params(2)-1));
residual(35) = exp(y(1))-params(11)*T(17)*T(32);
residual(36) = exp(y(21))-T(31)*T(22)*T(29)*T(36);
residual(37) = exp(y(20))-T(23)*T(28)*T(29)*T(40);
residual(38) = exp(y(12))-exp(y(18)*(1-params(3)))*exp(T(20)*y(23))*exp(y(17)*params(3));
residual(39) = exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))+exp(y(7))*params(6)*exp(y(11)*params(5))+exp(y(2))+exp(y(3))+exp(y(19))+exp(y(17))-(exp(y(16))+exp(y(17))*(1-params(10)));
residual(40) = exp(y(18))-T(51)*exp(y(21))^(1/params(8));
residual(41) = 1-exp(y(22))*(1+exp(y(20))-params(10));
residual(42) = exp(y(22))-params(1);
residual(43) = y(13)-exp(y(22))*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)));
residual(44) = y(14)-(y(14)*exp(y(22))*(1-params(7))+params(7)*y(13));
residual(45) = y(14)*T(8)*params(4)*exp(y(3)*(params(4)-1))-1;
residual(46) = T(53);
residual(47) = exp(y(7))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(9)));
residual(48) = exp(y(6))-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))+exp(y(8))*params(7));
residual(49) = exp(y(9))-((1-params(7))*exp(y(9))+T(8)*exp(y(3)*params(4)));
residual(50) = exp(y(8))-(exp(y(8))*(1-params(7))+T(6)*exp(y(2)*params(4)));
residual(51) = exp(y(5))-exp(y(11))*exp(y(7));
residual(52) = exp(y(4))-exp(y(6))*exp((-y(24)))*exp(y(10));
residual(53) = exp(y(15))-(exp(y(4))+exp(y(5)));
residual(54) = y(24)-x(1);
residual(55) = y(23)-(x(2)+y(23)*params(15)+y(23)*params(16));
residual(56) = exp(y(31))-exp(y(10));
residual(57) = y(25);
residual(58) = y(26);
residual(59) = y(27);
residual(60) = y(28);
residual(61) = y(29);
residual(62) = y(30);
residual(63) = y(32);
residual(64) = y(33);
lhs = y(65);
rhs = y(55);
residual(65) = lhs - rhs;
lhs = y(66);
rhs = y(23);
residual(66) = lhs - rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
end
